var get_board_type_xhr = new XMLHttpRequest();
var get_one_wire_xhr = new XMLHttpRequest();
var board_types = {reserved: 0, hdi: 1, di: 2, ai: 3, cti: 4, rtd: 5, ao: 7, ro: 8, hdo: 9
	, io1: 10, em_h: 16, em_l: 17, io3:18, hdi_5: 11, deleted: 255}
var selected_accordion = 0;
var boards_count = 9;
var one_wire_count = 16;


function form_tag_tr(param_name, eds_index, eds_subindex)
{
    var tr = $('<tr class="can_hide">').append($('<td>').text(param_name).addClass("name"));
	var div = $('<div>').addClass("tag").attr({"index": `${eds_index.toString(16).toUpperCase()}:${eds_subindex}`});
    tr.append($('<td>').append(div))//.addClass("name"));
    return tr;
}

function form_tag_tr2(param_name, eds_index, eds_subindex, param_name2, eds_index2, eds_subindex2)
{
    var tr = $('<tr class="can_hide">').append($('<td>').text(param_name).addClass("name"));
    var div = $('<div>').addClass("tag").attr({"index": `${eds_index.toString(16).toUpperCase()}:${eds_subindex}`});
    tr.append($('<td>').append(div))//.addClass("name"));
    tr.append($('<td>'))//.addClass('empty_space'));
    //tr.append($('<td>').text(param_name2).addClass("name"));
    var div2 = $('<div>').addClass("tag").attr({"index": `${eds_index2.toString(16).toUpperCase()}:${eds_subindex2}`});
    tr.append($('<td>').append(div2))//.addClass("name"));
    return tr;
}

function form_name_tr(param_name)
{
    return $('<tr class="can_hide">').append($('<td>').text(param_name).addClass("name")).append($('<td>'));
}

function form_tag_divide_tr(param_name, eds_index_num, eds_subindex_num, eds_index_den, eds_subindex_den)
{
    var tr = $('<tr class="can_hide">').append($('<td>').text(param_name).addClass("name"));
    var table = $('<table>');
    var div1 = $('<div>').addClass("io").addClass("tag").attr({"index": `${eds_index_num.toString(16).toUpperCase()}:${eds_subindex_num}`});
    var div2 = $('<div>').addClass("io").addClass("tag").attr({"index": `${eds_index_den.toString(16).toUpperCase()}:${eds_subindex_den}`});
    table.append($('<tr>').append(($('<td style="border-bottom-color: black">').append(div1))))
    table.append($('<tr>').append(($('<td>').append(div2))))
    tr.append($('<td>').append(table));
    return tr;
}

function form_multy_tag_tr(param_name, eds_index, count, start_index=1)
{
    var tr = $('<tr class="can_hide">').append($('<td>').text(param_name).addClass("name"));
    for (var eds_subindex = start_index; eds_subindex < start_index+count; eds_subindex++)
    {
        var div = $('<div>').addClass("io").addClass("tag").attr({"index": `${eds_index.toString(16).toUpperCase()}:${eds_subindex}`});
        tr.append($('<td>').append(div));
    }
    return tr;
}

function form_multy_header(param_name, count)
{
    var tr = $('<tr class="table_header">').append($('<td>').text(param_name).addClass("name"));
    for (var eds_subindex = 1; eds_subindex < count+1; eds_subindex++)
    {
        var div = $('<div>').text(eds_subindex);
        tr.append($('<td>').append(div));
    }
    return tr;
}

function create_block(element, data)
{
    var tr = $('<tr>')
    $.each(data.blocks, function(block_index, block_item)
    {
        var table_inner = $('<table>');
        $.each(block_item.params, function(param_index, param_item)
        {
            if (param_item.index != null && param_item.sub != null)
            {
                table_inner.append(form_tag_tr(param_item.name, param_item.index, param_item.sub));
            }
            else
            {
                table_inner.append(form_name_tr(param_item.name));
            }
        })
        td = $('<td>').append(table_inner)
        td_empty_space = $('<td>').addClass("empty_space")
        tr.append(td).append(td_empty_space)
    })

    element.append($('<table>').append(tr));
}

$(document).ready(function()
{
	var query = '/get_od_data.form?';
	query += `0x2000_2`; //product code
	// Request bords types 
    var start_number = 1;
    var end_number = boards_count;
    for (var board_number = start_number; board_number <= end_number; board_number++)
    {
        if(board_number<end_number)
        {
        var board_index = (0x4001 + (board_number - 1)*0x100).toString(16).toUpperCase()
        var board_div = $('<div>').addClass("board").attr({"id": `board_${board_number}`})
		var board_name = l100n.localize_string(`board_${board_number}`)
        var board_name_table = $('<table>').append(form_tag_tr(board_name, 0x4000 + (board_number - 1)*0x100, 1))
        board_name_table.addClass('board_name')
        var board_head = $('<div>').append(board_name_table).addClass("accordion-header").attr({"status_index": `${board_index}:1`})
        var board_body = $('<div>').addClass("accordion-body");
        //var table = $('<table>');
        //table.append(form_tag_tr("Name: ", 0x4000 + (board_number - 1)*0x100, 1));
        //table.append(form_tag_tr("Type: ", 0x1027, board_number + 1));
        //table.append(form_tag_tr("Board status: ", 0x4001 + (board_number - 1)*0x100, 1));
        //board_body.append(table);
        //board_body.append(`<div index="${0x4001 + (board_number - 1)*0x100}:1" class="tag"></div>`)

        var board_status = $('<div>').addClass('tag').addClass('board_status').attr({"index": `${board_index}:1`}).hide()
        board_body.append(board_status);
        board_div.append(board_head);
        board_div.append(board_body);
        $("#io_settings").append(board_div);
        }
        /*if (board_number >= start_number) { query += "&"; }*/
        query += `&0x1027_${(board_number)}`; //board type
	}	
    get_board_type_xhr.open('GET', query, true);
	get_board_type_xhr.send();	
});

function show_boards_by_type(types)
{
for (var board_number = 0; board_number < boards_count; board_number++)
{
//console.log("board_number "+board_number);
//console.log("types[board_number] "+types[board_number])
if (types[board_number] != null)
{
    var type = types[board_number].replace(/\u0000/g, '');
    var type1 = types[1].replace(/\u0000/g, '');

    if (type == board_types.deleted)
    {
	$(`#board_${board_number}`).hide();
    }
    else
    {
	var table = $('<table>').addClass('data_td');
	if (type == board_types.di)
	{
	    var count = 10;
	    if (board_number == 0) count = 5;
		table.append(form_multy_header("DI:", count));
	    table.append(form_multy_tag_tr(l100n.localize_string("value"), 0x3F11 + board_number*0x100, count).addClass("main_value"));
	    table.append(form_multy_tag_tr(l100n.localize_string("invert_polarity"), 0x3F12 + board_number*0x100, count));
	    table.append(form_multy_tag_tr(l100n.localize_string("Filter time, ms"), 0x3F13 + board_number*0x100, count));
	    $(`#board_${board_number}`).children('.accordion-body').append(table);
	}
	if (type == board_types.hdi)
	{
		var count = 10;
		if (board_number == 0) count = 5;
		if (type1 != board_types.io1)// If first board type not io1
		{
			table.append(form_multy_header("HDI:", count));
			table.append(form_multy_tag_tr(l100n.localize_string("value"), 0x3F11 + board_number * 0x100, count).addClass("main_value"));
			table.append(form_multy_tag_tr(l100n.localize_string("invert_polarity"), 0x3F12 + board_number * 0x100, count));
			table.append(form_multy_tag_tr(l100n.localize_string("Filter time, ms"), 0x3F13 + board_number * 0x100, count));
			$(`#board_${board_number}`).children('.accordion-body').append(table);
		}
	}
	else if (type == board_types.hdo)
	{
	    var count = 10;
	    if (board_number == 0) count = 5;
	    table.append(form_multy_header("HDO:", count));
	    table.append(form_multy_tag_tr(l100n.localize_string("value"), 0x3F21 + board_number*0x100, count).addClass("main_value"));
	    table.append(form_multy_tag_tr(l100n.localize_string("invert_polarity"), 0x3F22 + board_number*0x100, count));
	    table.append(form_multy_tag_tr(l100n.localize_string("Error mode"), 0x3F23 + board_number*0x100, count));
	    table.append(form_multy_tag_tr(l100n.localize_string("Error value"), 0x3F24 + board_number*0x100, count));
	    table.append(form_multy_tag_tr(l100n.localize_string("Filter mask"), 0x3F25 + board_number*0x100, count));
	    $(`#board_${board_number}`).children('.accordion-body').append(table);
	}
	else if ((type == board_types.ai) || (type == board_types.cti))
	{
	    var count = 8;
	    table.append(form_multy_header(l100n.localize_string("Channel:"), count));
	    table.append(form_multy_tag_tr(l100n.localize_string("value"), 0x3F31 + board_number*0x100, count).addClass("main_value"));
	    table.append(form_multy_tag_tr(l100n.localize_string("Scaling"), 0x3F32 + board_number*0x100, count));
	    table.append(form_multy_tag_tr(l100n.localize_string("Offset"), 0x3F33 + board_number*0x100, count));
	    table.append(form_multy_tag_tr(l100n.localize_string("Filter time, ms"), 0x3F34 + board_number*0x100, count));
	    table.append(form_multy_tag_tr(l100n.localize_string("Deadband Reference"), 0x3F3C + board_number*0x100, count));
	    table.append(form_multy_tag_tr(l100n.localize_string("Deadband, %"), 0x3F35 + board_number*0x100, count));
	    //table.append(form_multy_tag_tr("Float processed", 0x3F3B + board_number*0x100, count));
	    $(`#board_${board_number}`).children('.accordion-body').append(table);
	}
	else if (type == board_types.io3)
	{
		var main_div = $('<div>').addClass('tab-class');
		li=$('<li>').append($('<a>').prop('href',`#rtd-tab-${board_number}`).append("RTD"))
		ul=$('<ul>')
		ul.append(li).append($('<li>').append($('<a>').prop('href',`#cti-tab-${board_number}`).append("CTI")));
		ul.append($('<li>').append($('<a>').prop('href',`#ai-tab-${board_number}`).append("AI")));
		main_div.append(ul)

		tab_table = $('<table>')
		tbody_cti = $('<tbody>').prop('id',`cti-tab-${board_number}`)
		tbody_rtd = $('<tbody>').prop('id',`rtd-tab-${board_number}`)
		tbody_ai = $('<tbody>').prop('id',`ai-tab-${board_number}`)

	    var count = 2;
	    tbody_cti.append(form_multy_header(l100n.localize_string("Channel:"), count));
	    tbody_cti.append(form_multy_tag_tr(l100n.localize_string("value"), 0x3F31 + board_number*0x100, count).addClass("main_value"));
	    tbody_cti.append(form_multy_tag_tr(l100n.localize_string("Scaling"), 0x3F32 + board_number*0x100, count));
	    tbody_cti.append(form_multy_tag_tr(l100n.localize_string("Offset"), 0x3F33 + board_number*0x100, count));
	    tbody_cti.append(form_multy_tag_tr(l100n.localize_string("Filter time, ms"), 0x3F34 + board_number*0x100, count));
	    tbody_cti.append(form_multy_tag_tr(l100n.localize_string("Deadband Reference"), 0x3F3C + board_number*0x100, count));
	    tbody_cti.append(form_multy_tag_tr(l100n.localize_string("Deadband, %"), 0x3F35 + board_number*0x100, count));

	    //table.append(form_multy_tag_tr("Float processed", 0x3F3B + board_number*0x100, count));

	    tab_table.append(tbody_cti);

	    var count = 2;
	    var start=7;
	    tbody_rtd.append(form_multy_header(l100n.localize_string("Channel:"), count));
	    tbody_rtd.append(form_multy_tag_tr(l100n.localize_string("value"), 0x3F31 + board_number*0x100, count, start).addClass("main_value"));
	    tbody_rtd.append(form_multy_tag_tr(l100n.localize_string("Settings"), 0x3F39 + board_number*0x100, count, start));
	    tbody_rtd.append(form_multy_tag_tr(l100n.localize_string("Scaling"), 0x3F32 + board_number*0x100, count, start));
	    tbody_rtd.append(form_multy_tag_tr(l100n.localize_string("Offset"), 0x3F33 + board_number*0x100, count, start));
	    tbody_rtd.append(form_multy_tag_tr(l100n.localize_string("Filter time, ms"), 0x3F34 + board_number*0x100, count, start));
	    tbody_rtd.append(form_multy_tag_tr(l100n.localize_string("Deadband Reference"), 0x3F3C + board_number*0x100, count, start));
	    tbody_rtd.append(form_multy_tag_tr(l100n.localize_string("Deadband, %"), 0x3F35 + board_number*0x100, count, start));

	    //tbody_rtd.append(form_multy_tag_tr("Float processed", 0x3F3B + board_number*0x100, count));
	    tab_table.append(tbody_rtd)

	    var count = 2;
	    var start = 5;
	    tbody_ai.append(form_multy_header(l100n.localize_string("Channel:"), count));
	    tbody_ai.append(form_multy_tag_tr(l100n.localize_string("value"), 0x3F31 + board_number*0x100, count, start).addClass("main_value"));
	    tbody_ai.append(form_multy_tag_tr(l100n.localize_string("Scaling"), 0x3F32 + board_number*0x100, count, start));
	    tbody_ai.append(form_multy_tag_tr(l100n.localize_string("Offset"), 0x3F33 + board_number*0x100, count, start));
	    tbody_ai.append(form_multy_tag_tr(l100n.localize_string("Filter time, ms"), 0x3F34 + board_number*0x100, count, start));
	    tbody_ai.append(form_multy_tag_tr(l100n.localize_string("Deadband Reference"), 0x3F3C + board_number*0x100, count, start));
	    tbody_ai.append(form_multy_tag_tr(l100n.localize_string("Deadband, %"), 0x3F35 + board_number*0x100, count, start));

	    tab_table.append(tbody_ai)
	    main_div.append(tab_table)
	    //table.append(form_multy_tag_tr("Float processed", 0x3F3B + board_number*0x100, count));

	    $(`#board_${board_number}`).children('.accordion-body').append(main_div);
	}
	 else if (type == board_types.rtd)
	{
	    var count = 4;
	    table.append(form_multy_header(l100n.localize_string("Channel:"), count));
	    table.append(form_multy_tag_tr(l100n.localize_string("value"), 0x3F31 + board_number*0x100, count).addClass("main_value"));
	    table.append(form_multy_tag_tr(l100n.localize_string("Settings"), 0x3F39 + board_number*0x100, count));
	    table.append(form_multy_tag_tr(l100n.localize_string("Scaling"), 0x3F32 + board_number*0x100, count));
	    table.append(form_multy_tag_tr(l100n.localize_string("Offset"), 0x3F33 + board_number*0x100, count));
	    table.append(form_multy_tag_tr(l100n.localize_string("Filter time, ms"), 0x3F34 + board_number*0x100, count));
	    table.append(form_multy_tag_tr(l100n.localize_string("Deadband Reference"), 0x3F3C + board_number*0x100, count));
	    table.append(form_multy_tag_tr(l100n.localize_string("Deadband, %"), 0x3F35 + board_number*0x100, count));

	    //table.append(form_multy_tag_tr("Float processed", 0x3F3B + board_number*0x100, count));

	    $(`#board_${board_number}`).children('.accordion-body').append(table);
	}
	else if (type == board_types.ao)
	{
	    var count = 2;
	    table.append(form_multy_header(l100n.localize_string("Channel:"), count));
	    table.append(form_multy_tag_tr(l100n.localize_string("value"), 0x3F41 + board_number*0x100, count).addClass("main_value"));
	    table.append(form_multy_tag_tr(l100n.localize_string("Scaling"), 0x3F43 + board_number*0x100, count));
	    table.append(form_multy_tag_tr(l100n.localize_string("Offset"), 0x3F42 + board_number*0x100, count));
	    table.append(form_multy_tag_tr(l100n.localize_string("Error mode"), 0x3F44 + board_number*0x100, count));
	    table.append(form_multy_tag_tr(l100n.localize_string("Error value"), 0x3F45 + board_number*0x100, count));

	    $(`#board_${board_number}`).children('.accordion-body').append(table);
	}
	else if (type == board_types.ro)
	{
	    var count = 4;
	    table.append(form_multy_header("RO:", count));
	    table.append(form_multy_tag_tr(l100n.localize_string("value"), 0x3F21 + board_number*0x100, count).addClass("main_value"));
	    table.append(form_multy_tag_tr(l100n.localize_string("invert_polarity"), 0x3F22 + board_number*0x100, count));
	    table.append(form_multy_tag_tr(l100n.localize_string("Error mode"), 0x3F23 + board_number*0x100, count));
	    table.append(form_multy_tag_tr(l100n.localize_string("Error value"), 0x3F24 + board_number*0x100, count));
	    table.append(form_multy_tag_tr(l100n.localize_string("Filter mask"), 0x3F25 + board_number*0x100, count));

	    $(`#board_${board_number}`).children('.accordion-body').append(table);
	}
	else if (type == board_types.io1) 
	{
		var main_div = $('<div>').addClass('tab-class');
		li=$('<li>').append($('<a>').prop('href',`#di-tab-${board_number}`).append("DI"))
		ul=$('<ul>')
		ul.append(li).append($('<li>').append($('<a>').prop('href',`#do-tab-${board_number}`).append("DO")));
		ul.append($('<li>').append($('<a>').prop('href',`#alarm-tab-${board_number}`).append("Alarm")));
		main_div.append(ul)

		tab_table = $('<table>')
		tbody_di = $('<tbody>').prop('id',`di-tab-${board_number}`)
		tbody_do = $('<tbody>').prop('id',`do-tab-${board_number}`)
		tbody_alarm = $('<tbody>').prop('id',`alarm-tab-${board_number}`)

		var count = 5;
		tbody_di.append(form_multy_header("HDI:", count));
		tbody_di.append(form_multy_tag_tr(l100n.localize_string("value"), 0x3F11 + board_number * 0x100, count).addClass("main_value"));
		tbody_di.append(form_multy_tag_tr(l100n.localize_string("invert_polarity"), 0x3F12 + board_number * 0x100, count));
		tbody_di.append(form_multy_tag_tr(l100n.localize_string("Filter time, ms"), 0x3F13 + board_number * 0x100, count));

		count = 2;
		tbody_do.append(form_multy_header("HDO:", count));
		tbody_do.append(form_multy_tag_tr(l100n.localize_string("value"), 0x3F21 + board_number * 0x100, count).addClass("main_value"));
		tbody_do.append(form_multy_tag_tr(l100n.localize_string("invert_polarity"), 0x3F22 + board_number * 0x100, count));
		tbody_do.append(form_multy_tag_tr(l100n.localize_string("Error mode"), 0x3F23 + board_number * 0x100, count));
		tbody_do.append(form_multy_tag_tr(l100n.localize_string("Error value"), 0x3F24 + board_number * 0x100, count));
		tbody_do.append(form_multy_tag_tr(l100n.localize_string("Filter mask"), 0x3F25 + board_number * 0x100, count));
		main_div.append(tbody_do)

		count = 1;
		tbody_alarm.append(form_multy_header("Alarm Relay:", count));
		tbody_alarm.append(form_multy_tag_tr(l100n.localize_string("value"), 0x3F21 + 0 * 0x100, count).addClass("main_value"));
		tbody_alarm.append(form_multy_tag_tr(l100n.localize_string("invert_polarity"), 0x3F22 + 0 * 0x100, count));
		tbody_alarm.append(form_multy_tag_tr(l100n.localize_string("Error mode"), 0x3F23 + 0 * 0x100, count));
		tbody_alarm.append(form_multy_tag_tr(l100n.localize_string("Error value"), 0x3F24 + 0 * 0x100, count));
		tbody_alarm.append(form_multy_tag_tr(l100n.localize_string("Filter mask"), 0x3F25 + 0 * 0x100, count));
		tab_table.append(tbody_alarm)
		tab_table.append(tbody_do);
		tab_table.append(tbody_di);

		main_div.append(tab_table);
		$(`#board_${board_number}`).children('.accordion-body').append(main_div);
	}
	else if ((type == board_types.em_h) || (type == board_types.em_l))
	{
		var main_description = {name: l100n.localize_string("C V PF"), blocks: [
			{params: [
			    {name: "Ia, A: ", index: 0x4064, sub: 1},
			    {name: "Ib, A: ", index: 0x4064, sub: 2},
			    {name: "Ic, A: ", index: 0x4064, sub: 3},
			    {name: "Iavg, A: ", index: 0x4064, sub: 5},
			    {name: `Id, ${l100n.localize_string("mA")}: `, index: 0x4064, sub: 4}
			]},
			{params: [
			    {name: `Ua, ${l100n.localize_string("V")}: `, index: 0x4065, sub: 1},
			    {name: `Ub, ${l100n.localize_string("V")}: `, index: 0x4065, sub: 2},
			    {name: `Uc, ${l100n.localize_string("V")}: `, index: 0x4065, sub: 3},
			    {name: `Uavg, ${l100n.localize_string("V")}: `, index: 0x4065, sub: 4}
			]},
			{params: [
			    {name: `Uab, ${l100n.localize_string("V")}: `, index: 0x4065, sub: 5},
			    {name: `Ubc, ${l100n.localize_string("V")}: `, index: 0x4065, sub: 6},
			    {name: `Uca, ${l100n.localize_string("V")}: `, index: 0x4065, sub: 7},
			    {name: `ULavg, ${l100n.localize_string("V")}: `, index: 0x4065, sub: 8}
			]},
			{params: [
			    {name: "PFa: ", index: 0x4066, sub: 13},
			    {name: "PFb: ", index: 0x4066, sub: 14},
			    {name: "PFc: ", index: 0x4066, sub: 15},
			    {name: "PFavg: ", index: 0x4066, sub: 16}
			]}
		]}
	    var power = {name: l100n.localize_string("Power"), blocks: [
			{params: [
			    {name: `Pa, ${l100n.localize_string("kW")}: `, index: 0x4066, sub: 1},
			    {name: `Pb, ${l100n.localize_string("kW")}: `, index: 0x4066, sub: 2},
			    {name: `Pc, ${l100n.localize_string("kW")}: `, index: 0x4066, sub: 3},
			    {name: `P, ${l100n.localize_string("kW")}: `, index: 0x4066, sub: 4}
			]},
			{params: [
			    {name: `Qa, ${l100n.localize_string("kvar")}: `, index: 0x4066, sub: 5},
			    {name: `Qb, ${l100n.localize_string("kvar")}: `, index: 0x4066, sub: 6},
			    {name: `Qc, ${l100n.localize_string("kvar")}: `, index: 0x4066, sub: 7},
			    {name: `Q, ${l100n.localize_string("kvar")}: `, index: 0x4066, sub: 8}
			]},
			{params: [
			    {name: `Sa, ${l100n.localize_string("kVA")}: `, index: 0x4066, sub: 9},
			    {name: `Sb, ${l100n.localize_string("kVA")}: `, index: 0x4066, sub: 10},
			    {name: `Sc, ${l100n.localize_string("kVA")}: `, index: 0x4066, sub: 11},
			    {name: `S, ${l100n.localize_string("kVA")}: `, index: 0x4066, sub: 12}
			]}
		]}
	    var energy = {name: l100n.localize_string("Energy"), blocks: [
			{params: [
			    {name: "Wa+: ", index: 0x4067, sub: 2},
			    {name: "Wb+: ", index: 0x4067, sub: 3},
			    {name: "Wc+: ", index: 0x4067, sub: 4},
			    {name: "W+: ", index: 0x4067, sub: 5}
			]},
			{params: [
			    {name: "Wa-: ", index: 0x4067, sub: 6},
			    {name: "Wb-: ", index: 0x4067, sub: 7},
			    {name: "Wc-: ", index: 0x4067, sub: 8},
			    {name: "W-: ", index: 0x4067, sub: 9}
			]},
			{params: [
			    {name: "WQa+: ", index: 0x4067, sub: 10},
			    {name: "WQb+: ", index: 0x4067, sub: 11},
			    {name: "WQc+: ", index: 0x4067, sub: 12},
			    {name: "WQ+: ", index: 0x4067, sub: 13}
			]},
			{params: [
			    {name: "WQa-: ", index: 0x4067, sub: 14},
			    {name: "WQb-: ", index: 0x4067, sub: 15},
			    {name: "WQc-: ", index: 0x4067, sub: 16},
			    {name: "WQ-: ", index: 0x4067, sub: 17}
			]},
			{params: [
			    {name: "WSa: ", index: 0x4067, sub: 18},
			    {name: "WSb: ", index: 0x4067, sub: 19},
			    {name: "WSc: ", index: 0x4067, sub: 20},
			    {name: "WS: ", index: 0x4067, sub: 21}
			]}
		]}
	    var quality = {name: l100n.localize_string("Quality"), blocks: [
			{params: [
			    {name: `F, ${l100n.localize_string("Hz")}: `, index: 0x4068, sub: 1}
			]},
			{params: [
			    {name: "THD Ua, %: ", index: 0x4068, sub: 2},
			    {name: "THD Ub, %: ", index: 0x4068, sub: 3},
			    {name: "THD Uc, %: ", index: 0x4068, sub: 4},
			    {name: "THD Uavg, %: ", index: 0x4068, sub: 5}
			]},
			{params: [
			    {name: "THD Ia, %: ", index: 0x4068, sub: 6},
			    {name: "THD Ib, %: ", index: 0x4068, sub: 7},
			    {name: "THD Ic, %: ", index: 0x4068, sub: 8},
			    {name: "THD Iavg, %: ", index: 0x4068, sub: 9}
			]}
		]}

		var ul = $('<ul>')
		ul.append($(`<li><a href="#em_settings-tab${board_number}">${l100n.localize_string("Settings")}</a></li>`))
		ul.append($(`<li><a href="#em_db_settings-tab${board_number}">${l100n.localize_string("Deadband Settings")}</a></li>`))
		ul.append($(`<li><a href="#em_main_description-tab${board_number}">${main_description.name}</a></li>`))
		ul.append($(`<li><a href="#em_power-tab${board_number}">${power.name}</a></li>`))
		ul.append($(`<li><a href="#em_energy-tab${board_number}">${energy.name}</a></li>`))
		ul.append($(`<li><a href="#em_quality-tab${board_number}">${quality.name}</a></li>`))
		ul.append($(`<li><a href="#em_statistics-tab${board_number}">${l100n.localize_string("Statistics")}</a></li>`))
		var em_settings_tbody = $(`<tbody id="em_settings-tab${board_number}">`).addClass('nowrap_td')
		var em_db_settings_tbody = $(`<tbody id="em_db_settings-tab${board_number}">`).addClass('data_td').addClass('nowrap_td')
		var em_main_description_tbody = $(`<tbody id="em_main_description-tab${board_number}">`).addClass('nowrap_td')
		var em_power_tbody = $(`<tbody id="em_power-tab${board_number}">`).addClass('nowrap_td')
		var em_energy_tbody = $(`<tbody id="em_energy-tab${board_number}">`).addClass('nowrap_td')
		var em_quality_tbody = $(`<tbody id="em_quality-tab${board_number}">`).addClass('nowrap_td')
		var em_statistics_tbody = $(`<tbody id="em_statistics-tab${board_number}">`).addClass('nowrap_td')

		em_settings_tbody.append(form_tag_tr(l100n.localize_string("Scheme"), 0x4060, 1));
	    em_settings_tbody.append(form_tag_tr(l100n.localize_string("Current range"), 0x4060, 2));
	    em_settings_tbody.append(form_tag_tr(l100n.localize_string("Current range Lkg"), 0x4060, 3));
	    em_settings_tbody.append(form_tag_divide_tr(l100n.localize_string("CTR"), 0x4060, 4, 0x4060, 5));
	    em_settings_tbody.append(form_tag_divide_tr(l100n.localize_string("CTR Lkg"), 0x4060, 6, 0x4060, 7));
	    em_settings_tbody.append(form_tag_divide_tr(l100n.localize_string("VTR"), 0x4060, 8, 0x4060, 9));

		var table_head = $('<tr>').addClass('table_header');
		table_head.append($('<td colspan="1">').text(""));
	    table_head.append($('<td colspan="2">').text(l100n.localize_string("Deadband Reference")));
		table_head.append($('<td colspan="2">').text(l100n.localize_string("Deadband, %")))
		em_db_settings_tbody.append(table_head)
	    em_db_settings_tbody.append(form_tag_tr2("Ia, Ib, Ic, A: ", 0x4072, 1, " ", 0x406E, 1));
	    em_db_settings_tbody.append(form_tag_tr2("Id, A: ", 0x4072, 2, " ", 0x406E, 2));
	    em_db_settings_tbody.append(form_tag_tr2(`U, ${l100n.localize_string("V")}: `, 0x4073, 1, " ", 0x406F, 1));
		em_db_settings_tbody.append(form_tag_tr2(`P, ${l100n.localize_string("kW")}/ Q, ${l100n.localize_string("kvar")}/ S, ${l100n.localize_string("kVA")}: `, 0x4074, 1, " ", 0x4070, 1));
	    em_db_settings_tbody.append(form_tag_tr2("PF: ", 0x4074, 3, " ", 0x4070, 2));
	    em_db_settings_tbody.append(form_tag_tr2(`F, ${l100n.localize_string("Hz")}: `, 0x4075, 1, " ", 0x4071, 1));
	    em_db_settings_tbody.append(form_tag_tr2("THD I, %: ", 0x4075, 2, " ", 0x4071, 2));
		em_db_settings_tbody.append(form_tag_tr2("THD U, %: ", 0x4075, 2, " ", 0x4071, 3));
		
		create_block(em_main_description_tbody, main_description)
		
		create_block(em_power_tbody, power)
		
		var td1_pulsQty = $('<td>').text(`pulsQty, ${l100n.localize_string("kWh")}/${l100n.localize_string("kvarh")}/${l100n.localize_string("kVAh")}: `);
		var td2_pulsQty = $('<td>').append($('<div>').addClass("io").addClass("tag").attr({"index": "4067:1"}));
		var tr_pulsQty = $('<tr class="can_hide">').append(td1_pulsQty).append(td2_pulsQty);
	    var table_pulsQty = $('<table>').append(tr_pulsQty)
	    em_energy_tbody.append(table_pulsQty)
		create_block(em_energy_tbody, energy)
		var em_energy_button = ($(`<input type="submit" value="${l100n.localize_string("COMMAND_CLEAR_ENERGY")}" id="COMMAND_CLEAR_ENERGY" board_number="${board_number}">`))
		em_energy_tbody.append(em_energy_button)

		create_block(em_quality_tbody, quality)

		em_statistics_tbody.append(form_tag_tr(`${l100n.localize_string("Operating Hours")} A`, 0x4069, 1));
		em_statistics_tbody.append(form_tag_tr(`${l100n.localize_string("Operating Hours")} B`, 0x4069, 2));
		em_statistics_tbody.append(form_tag_tr(`${l100n.localize_string("Operating Hours")} C`, 0x4069, 3));
		em_statistics_tbody.append(form_tag_tr(l100n.localize_string("Total Operating Hours"), 0x4069, 4));
		var em_statistics_button = ($(`<input type="submit" value="${l100n.localize_string("COMMAND_CLEAR_MTHRS")}" id="COMMAND_CLEAR_MTHRS" board_number="${board_number}">`))
		em_statistics_tbody.append(em_statistics_button)

		var table = $('<table>')
		table.append(em_settings_tbody).append(em_db_settings_tbody).append(em_main_description_tbody).append(em_power_tbody).append(em_energy_tbody).append(em_quality_tbody).append(em_statistics_tbody)
		var tabs_div = $('<div class="tab-class">').append(ul).append(table)
		$(`#board_${board_number}`).children('.accordion-body').append(tabs_div)
	}
    }
}
else
{
    $(`#board_${board_number}`).hide();
}
}
}

$(document).on('click', '#COMMAND_CLEAR_MTHRS', function()
{
	result = confirm(l100n.localize_string("COMMAND_CLEAR_MTHRS_confirm_question"));
	if (result == true)
	{
		var board_number = $(this).attr("board_number");
		var query = `/set_od_data.form?0x4${board_number-1}03_1=0x73726872`;
		button_command_xhr.open('GET', query, true);
		button_command_xhr.send();
	}
});

$(document).on('click', '#COMMAND_CLEAR_ENERGY', function()
{
	result = confirm(l100n.localize_string("COMMAND_CLEAR_ENERGY_confirm_question"));
	if (result == true)
	{
		var board_number = $(this).attr("board_number");
		var query = `/set_od_data.form?0x4${board_number-1}03_1=0x746e6372`;
		button_command_xhr.open('GET', query, true);
		button_command_xhr.send();
	}
});

function show_one_wire(sensorsId)
{
	if (!$.isEmptyObject(sensorsId))
	{
		var h3 = $(`<h3>`).text(l100n.localize_string("ext_Channels_header"))
		var commands = [{"name": l100n.localize_string("not selected"), "command": "0x0"}]
		sensorsId.forEach(function(id, i) {
			commands.push({"name": id, "command": id})
		});

		var sensors_table = $('<table>');
		var table_head = $('<tr>').addClass('table_header')
		table_head.append($('<td colspan="1">').text(""))
	    table_head.append($('<td colspan="1">').text(l100n.localize_string("ext_Settings")))
		table_head.append($('<td colspan="1">').text(l100n.localize_string("AI Read Float")))
		sensors_table.append(table_head)
		
		var start_number = 1;
		var end_number = one_wire_count;
		for (var sensor_number = start_number; sensor_number <= end_number; sensor_number++)
		{
			configuration.add_template({"index": `4808_${sensor_number}`,"template": "combobox", "commands": commands})
			var tr = $('<tr class="can_hide">').append($('<td>').text(`${l100n.localize_string("ext_Channel")} ${sensor_number} `))
			tr.append($('<td>').append($('<div class="sensor_select">').addClass("tag").attr({"index": `4808:${sensor_number}`})))
			tr.append($('<td>').append($('<div>').addClass("tag").attr({"index": `4831:${sensor_number}`})))
			sensors_table.append(tr)
		}

		//var sensors_div = $('<div>').addClass("board")		
		var sensors_head = $('<div>').text(l100n.localize_string("1 Wire accordion header")).addClass("accordion-header")
		var sensors_body = $('<div>').append(sensors_table).addClass("accordion-body")
		$("#boyan").append(h3).append(sensors_head).append(sensors_body)
		//$("#io_settings").append(sensors_div)

	}
	//console.log(configuration.data_type_template().templates)
}

function response_one_wire()
{
	// Request 1-Wire sensors
	var query2 = '/get_od_data.form?';
	var start_number = 1;
	var end_number = one_wire_count;
	for (var sensor_number = start_number; sensor_number <= end_number; sensor_number++)
	{
		if (sensor_number > start_number) { query2 += "&"; }
		query2 += `0x480A_${sensor_number}`; //sensor ID
	}
	get_one_wire_xhr.open('GET', query2, true);
	get_one_wire_xhr.send();
} 

function response_ready()
{
	var values = get_response_values(get_board_type_xhr)
	var product_code = values[0]
	var types = values.slice(1)	
	
	var product_code_arr = get_set_value.ip2array(product_code)
	//console.log(product_code_arr)
	if (product_code_arr[0] == 11) //EM-12
	{
		var board_index = "0x3F01"
		var board_status = $('<div>').addClass('tag').addClass('board_status').attr({"index": `${board_index}:1`}).hide()
		var board_body = $('<div>').addClass("accordion-body").append(board_status);
		var board_div = $('<div>').addClass("board").attr({"id": `board_0`}).append(board_body);
		$("#board_head").append(board_div);
	}

	show_boards_by_type(types)
	//user.parse_page()
	$('.can_hide').each(function( index )
	{
		var form = $(this).children('.value_td').children('.tag').children('.apply_form')
		if ($(form).hasClass('empty')) { $(this).hide() }
	});
	$("div[index='1001:0']").hide()
	$(".tab-class").tabs();

	response_one_wire()
}

function response_one_wire_ready()
{
	var values = get_response_values(get_one_wire_xhr)
	console.log(values)
	let sensors_ID = values.filter(element => element !== "0x0");
	console.log(sensors_ID)
	show_one_wire(sensors_ID)

	$("#boyan").accordion({ heightStyle: 'content', header: '.accordion-header', active: 0});
	$("#boyan").accordion( "option", "collapsible", true );
	user.parse_page()
}

function get_response_values(xhr)
{
	var response_values = [];
	var responseLines = xhr.responseText.split('\n');
	var responseLine = responseLines[1];
	//console.log("responseLine:"+responseLine);
	/*if ((responseLines[1].search( />>>ERROR<<</i ) != -1) || (responseLines[1].search( /!!!ERROR!!!/i ) != -1))
    {
        alert('Ошибка в ответе с сервера:' + responseLine);
    }*/

    response_values = responseLine.split('&#&');
    response_values.pop();
    //console.log('response_values: ' + response_values);
    return response_values;
}

$(document).on('click', '.accordion-header', function()
{
    selected_accordion = $(this).index();
});

$(document).on('value_loaded', 'div[tb_index="1001_0"]', function( e )
{
    var device_error = $(this).text()
    if (device_error > 0)
    {
        $('.device_status').addClass('device_error')
    }
    else
    {
        $('.device_status').removeClass('device_error')
    }

    $(this).removeClass('value_loaded')
});

$(document).on('value_loaded', '.board_status', function( e )
{
    var board = $(this).children('form').children('div.value')
    var board_error = board.text()
    var status_index = $(this).attr('index')
    if (board_error > 0)
    {
        $(`div[status_index="${status_index}"]`).addClass('device_error')
    }
    else
    {
        $(`div[status_index="${status_index}"]`).removeClass('device_error')
    }

    //$(this).removeClass('board_error')
    $(this).removeClass('value_loaded')
});

get_board_type_xhr.onreadystatechange = function()
{
    //console.log(get_board_type_xhr.readyState);
    if (get_board_type_xhr.readyState == 4)
    {
        if (get_board_type_xhr.status == 200)
        {
            response_ready();
        }
        else
        {
            alert("Проверьте соединение с контроллером...");
        }
    }
}

get_one_wire_xhr.onreadystatechange = function()
{
    //console.log(get_one_wire_xhr.readyState);
    if (get_one_wire_xhr.readyState == 4)
    {
        if (get_one_wire_xhr.status == 200)
        {
            response_one_wire_ready();
        }
        else
        {
            alert("Проверьте соединение с контроллером...");
        }
    }
}